/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation.library.modifiers;

import com.gjhi.tinkersinnovation.register.TinkersInnovationUtils;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.behavior.AttributesModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.build.ModifierRemovalHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.DamageDealtModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class OverImitateArmorModifier
extends Modifier
implements AttributesModifierHook,
ModifierRemovalHook,
DamageDealtModifierHook,
TooltipModifierHook {
    private final ResourceLocation KEY_ARMOR = new ResourceLocation("tinkersinnovation", "over_imitate_armor");
    private final ResourceLocation KEY_TOUGHNESS = new ResourceLocation("tinkersinnovation", "over_imitate_toughness");

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.DAMAGE_DEALT, ModifierHooks.ATTRIBUTES, ModifierHooks.REMOVE, ModifierHooks.TOOLTIP});
    }

    void modifyImitateArmor(ModDataNBT data, float factor) {
        data.putFloat(this.KEY_ARMOR, data.getFloat(this.KEY_ARMOR) * factor);
    }

    void modifyImitateToughness(ModDataNBT data, float factor) {
        data.putFloat(this.KEY_TOUGHNESS, data.getFloat(this.KEY_TOUGHNESS) * factor);
    }

    public void addAttributes(IToolStackView tool, ModifierEntry modifier, EquipmentSlot slot, BiConsumer<Attribute, AttributeModifier> consumer) {
        if (TinkersInnovationUtils.isInArmorSlots(slot) || TinkersInnovationUtils.isShieldInHandSlots(tool, slot)) {
            float boost_armor = tool.getPersistentData().getFloat(this.KEY_ARMOR);
            float boost_toughness = tool.getPersistentData().getFloat(this.KEY_TOUGHNESS);
            if (boost_armor >= 0.0f) {
                consumer.accept(Attributes.f_22284_, new AttributeModifier(UUID.fromString("116aab4f-49fb-4366-8bc1-dceba697fece"), Attributes.f_22284_.m_22087_(), 0.2 * (double)modifier.getLevel() * (double)boost_armor, AttributeModifier.Operation.ADDITION));
            }
            if (boost_toughness >= 0.0f) {
                consumer.accept(Attributes.f_22285_, new AttributeModifier(UUID.fromString("94e7c303-808f-4966-9c2b-6e678a0cb8bd"), Attributes.f_22285_.m_22087_(), 0.2 * (double)modifier.getLevel() * (double)boost_toughness, AttributeModifier.Operation.ADDITION));
            }
        }
    }

    public Component onRemoved(IToolStackView tool, Modifier modifier) {
        tool.getPersistentData().remove((ResourceLocation)modifier.getId());
        return null;
    }

    public void onDamageDealt(IToolStackView tool, ModifierEntry modifier, EquipmentContext context, EquipmentSlot slotType, LivingEntity target, DamageSource source, float amount, boolean isDirectDamage) {
        ModDataNBT data = tool.getPersistentData();
        AttributeInstance attribute_armor = target.m_21051_(Attributes.f_22284_);
        AttributeInstance attribute_toughness = target.m_21051_(Attributes.f_22285_);
        if (attribute_armor != null) {
            data.putFloat(this.KEY_ARMOR, (float)attribute_armor.m_22135_() * 0.2f * (float)modifier.getLevel());
        }
        if (attribute_toughness != null) {
            data.putFloat(this.KEY_TOUGHNESS, (float)attribute_toughness.m_22135_() * 0.2f * (float)modifier.getLevel());
        }
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.over_imitate_armor", (Object[])new Object[]{Float.valueOf(tool.getPersistentData().getFloat(this.KEY_ARMOR))}));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.tinkersinnovation.over_imitate_toughness", (Object[])new Object[]{Float.valueOf(tool.getPersistentData().getFloat(this.KEY_TOUGHNESS))}));
    }
}

